/* Wiktor Zychla, 2003 IterSort: Eric Gunnerson*/
using System;
using System.Collections;

namespace Example
{
  public class IterIsolate: IEnumerable
  {
    ... jak wyej ...
  }

  public class IterSort: IterIsolate, IEnumerable
  {
    internal class IterSortEnumerator: IterIsolateEnumerator, IEnumerator
    {
      internal IterSortEnumerator(IEnumerator enumerator, IComparer comparer): base(enumerator)
      {
        if (comparer != null)
        {
          items.Sort(comparer);
        }
        else
        {
          items.Sort();
        }
      }
    }

    public IterSort(IEnumerable enumerable): base(enumerable) {}

    public IterSort(IEnumerable enumerable, IComparer comparer): base(enumerable)
    {
      this.comparer = comparer;
    }

    public new IEnumerator GetEnumerator()
    {
      return new IterSortEnumerator(enumerable.GetEnumerator(), comparer);
    }
    IComparer comparer;
  }

  public class COsoba : IComparable
  {
    ... jak wyej ...
  }

  public class CExample 
  {
    public static void Main(string[] args)
    {
      Hashtable hOsoby = new Hashtable();

      // w kolekcji pamitamy pary : ID -> Osoba
      hOsoby.Add( 7,  new COsoba( "Jan",      "Kowalski", "1994-03-01" ) );
      hOsoby.Add( 10, new COsoba( "Zdzisaw", "Kowalski", "1992-11-29" ) );
      hOsoby.Add( 3,  new COsoba( "Jan",    "Malinowski", "1990-02-16" ) );
      hOsoby.Add( 17, new COsoba( "Tomasz",   "Abacki"  , "1991-01-12" ) );

      // przegldaj kolekcj
      foreach ( COsoba o in hOsoby.Values )
        Console.WriteLine( o.ToString() );

      Console.WriteLine();
       
      // przegldaj posortowan kolekcj
      foreach ( COsoba o in 
                 new IterSort( hOsoby.Values, COsoba.SortByDataUr ) )
        Console.WriteLine( o.ToString() );
    }
  }
}
